<?php
/**
 * After setup theme hook
 */
function paradise_spa_theme_setup(){

    add_theme_support( "title-tag" );
    add_theme_support( 'automatic-feed-links' );
    
    /*
     * Make chile theme available for translation.
     * Translations can be filed in the /languages/ directory.
     */
    load_child_theme_textdomain( 'paradise-spa', get_stylesheet_directory() . '/languages' );

}
add_action( 'after_setup_theme', 'paradise_spa_theme_setup' );

/**
 * Load assets.
 *
 */
function paradise_spa_enqueue_styles() {
    $my_theme = wp_get_theme();
    $version = $my_theme['Version'];
    
    wp_enqueue_style( 'spa-and-salon-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'paradise-spa-style', get_stylesheet_directory_uri() . '/style.css', array( 'spa-and-salon-style' ), $version );
}
add_action( 'wp_enqueue_scripts', 'paradise_spa_enqueue_styles' );

function paradise_spa_customize_register_settings( $wp_customize ) {

    /** Working Hours */
    $wp_customize->add_setting( 'paradise_spa_header_hours', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         => 'postMessage'
        )
    );

    $wp_customize->add_control(
        'paradise_spa_header_hours',
        array(
            'label'   => __( 'Enter Working Hours', 'paradise-spa' ),
            'section' => 'spa_and_salon_header_section_settings',
            'type'    => 'text'
        )
    ); 

    $wp_customize->selective_refresh->add_partial( 'paradise_spa_header_hours', array(
        'selector'        => '.header-left .work-hr',
        'render_callback' => 'paradise_spa_header_hours_partial',
    ) );

    /** Header Email */
    $wp_customize->add_setting( 'paradise_spa_header_email', array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_email',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'paradise_spa_header_email',
        array(
            'label'   => __( 'Enter Email Address', 'paradise-spa' ),
            'section' => 'spa_and_salon_header_section_settings',
            'type'    => 'text'
        )
    );
    $wp_customize->selective_refresh->add_partial( 'paradise_spa_header_email', array(
        'selector'        => '.header-left .email',
        'render_callback' => 'paradise_spa_header_email_partial',
    ) );  
}
add_action( 'customize_register', 'paradise_spa_customize_register_settings' );

/**
 * Header Working Hour Partial Refresh
*/
function paradise_spa_header_hours_partial(){
    return esc_html( get_theme_mod( 'paradise_spa_header_hours' ) );
}

/**
 * Header Email Partial Refresh
*/
function paradise_spa_header_email_partial(){
    return esc_html( get_theme_mod( 'paradise_spa_header_email' ) );
}

/**
 * Register custom fonts.
 */
function spa_and_salon_fonts_url() {
    $fonts_url = '';

    /*
    * translators: If there are characters in your language that are not supported
    * by Marcellus, translate this to 'off'. Do not translate into your own language.
    */
    $marcellus = _x( 'on', 'Marcellus font: on or off', 'paradise-spa' );
    
    /*
    * translators: If there are characters in your language that are not supported
    * by Lato, translate this to 'off'. Do not translate into your own language.
    */
    $lato    = _x( 'on', 'Lato font: on or off', 'paradise-spa' );
    $libre   = _x( 'on', 'Libre Baskerville font: on or off', 'paradise-spa' );
    $manrope = _x( 'on', 'Manrope font: on or off', 'paradise-spa' );

    if ( 'off' !== $marcellus || 'off' !== $lato || 'off' !== $libre  || 'off' !== $manrope ) {
        $font_families = array();

        if( 'off' !== $marcellus ){
            $font_families[] = 'Marcellus';
        }

        if( 'off' !== $lato ){
            $font_families[] = 'Lato:400,700';
        }

        if( 'off' !== $libre ){
            $font_families[] = 'Libre Baskerville';
        }

        if( 'off' !== $manrope ){
            $font_families[] = 'Manrope';
        }

        $query_args = array(
            'family'  => urlencode( implode( '|', $font_families ) ),
            'display' => urlencode( 'fallback' ),
        );

        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }

    return esc_url( $fonts_url );
}

/**
 * Site Branding
*/
function spa_and_salon_site_branding(){
    $header_text = get_theme_mod( 'header_text', 1 );
    ?>
    <div class="site-branding" itemscope itemtype="https://schema.org/Organization">
        <?php 
        if( function_exists( 'has_custom_logo' ) && has_custom_logo() ) the_custom_logo();

        if( $header_text ){
            echo '<div class="site-info">';
                if ( is_front_page() ) : ?>
                <h1 class="site-title" itemprop="name"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                <?php else : ?>
                    <p class="site-title" itemprop="name"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                <?php endif;
                $description = get_bloginfo( 'description', 'display' );
                if ( $description || is_customize_preview() ) : ?>
                    <p class="site-description" itemprop="description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
                    <?php
                endif; 
            echo '</div>';
        } ?>
    </div> <!-- .site-branding -->
    <?php
}

/**
 * Header Start
*/
function spa_and_salon_header(){
    $phone        = get_theme_mod( 'spa_and_salon_ph', esc_html__( '01-234566789', 'paradise-spa' ) );
    $social_links = get_theme_mod( 'spa_and_salon_social_ed_header', false );
    $email        = get_theme_mod( 'paradise_spa_header_email', '' );
    $work_hr      = get_theme_mod( 'paradise_spa_header_hours', '' );

    ?>
    <header id="masthead" class="site-header style-two <?php if( !is_page_template( 'template-home.php' ) ) { echo 'header-inner'; }  ?>" role="banner" itemscope itemtype="https://schema.org/WPHeader">
        <?php if( $email || $work_hr || $phone || $social_links ){
            echo '<div class="header-t"><div class="container"><div class="header-t-wrapper">';
                if( $work_hr || $email || $phone ){
                    echo '<div class="header-left">';
                        if( $work_hr ) echo '<div class="work-hr"><span class="fa fa-clock"></span>'.esc_html($work_hr).'</div>';

                        if( $email ) echo '<div class="email"><span class="fa fa-envelope"></span><a href="mailto:'.sanitize_email( $email ).'" class="email-link">'.esc_html( $email ).'</a></div>';
                        
                        if( $phone ){ ?>
                            <a href="<?php echo esc_url( 'tel:' . preg_replace( '/[^\d+]/', '', $phone ) ); ?>" class="tel-link">
                            <span class="fa fa-phone"></span>
                            <?php echo esc_html( $phone ); ?></a>
                        <?php } 
                    echo '</div>';
                }
                if( $social_links ){ 
                    echo '<div class="header-right">';
                        if( $social_links ) do_action( 'spa_and_salon_social_link' ); 
                    echo '</div>';
                }             
            echo '</div></div></div>'; 
        } ?>    
        <div class="header-m">
            <div class="container">
                <div class="header-m-wrapper">
                    <?php 
                        spa_and_salon_site_branding();
                    ?>  
                </div>
            </div>
        </div>

        <div class="header-b">
            <div class="container">
                <div class="header-b-wrapper">
                    <?php spa_and_salon_navigation(); ?>  
                </div>
            </div>
        </div>    
    </header><!-- #masthead -->
<?php
}