<?php
/**
 * Header Layout 2
 *
 * @package Multi Blog
 */
$multi_blog_default = multi_blog_get_default_theme_options();
?>
<header id="site-header" class="site-header-layout header-layout-2" role="banner">
    <div class="header-navbar">
        <div class="wrapper header-wrapper">
            <div class="theme-header-areas header-areas-left">
                <div class="header-titles">
                    <?php
                    // Site title or logo.
                    multi_blog_site_logo();
                    // Site description.
                    multi_blog_site_description();
                    ?>
                </div><!-- .header-titles -->
            </div>
            <div class="theme-header-areas header-areas-right">
                <div class="site-navigation">
                    <nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e('Horizontal', 'multi-blog'); ?>"
                         role="navigation">
                        <ul class="primary-menu theme-menu">
                            <?php
                            if (has_nav_menu('multi-blog-primary-menu')) {
                                wp_nav_menu(
                                    array(
                                        'container' => '',
                                        'items_wrap' => '%3$s',
                                        'theme_location' => 'multi-blog-primary-menu',
                                        'walker' => new multiblog\Multi_Blog_Walkernav(),
                                    )
                                );
                            } else {
                                wp_list_pages(
                                    array(
                                        'match_menu_classes' => true,
                                        'show_sub_menu_icons' => true,
                                        'title_li' => false,
                                        'walker' => new Multi_Blog_Walker_Page(),
                                    )
                                );
                            } ?>
                        </ul>
                    </nav>
                </div>
                <div class="navbar-controls twp-hide-js">
                    <button type="button" class="navbar-control navbar-control-offcanvas">
                             <span class="navbar-control-trigger" tabindex="-1">
                                <?php multi_blog_the_theme_svg('menu'); ?>
                             </span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</header><!-- #site-header -->
