<?php
if ( !class_exists('Multi_Blog_Dashboard_Notice') ):

    class Multi_Blog_Dashboard_Notice
    {
        function __construct()
        {	
            global $pagenow;

        	if( $this->multi_blog_show_hide_notice() ){

	            add_action( 'admin_notices',array( $this,'multi_blog_admin_notice' ) );
	        }
	        add_action( 'wp_ajax_multi_blog_notice_dismiss', array( $this, 'multi_blog_notice_dismiss' ) );
			add_action( 'switch_theme', array( $this, 'multi_blog_notice_clear_cache' ) );
        
            if( isset( $_GET['page'] ) && $_GET['page'] == 'multi-blog-about' ){

                add_action('in_admin_header', array( $this,'multi_blog_hide_all_admin_notice' ),1000 );

            }
        }

        public function multi_blog_hide_all_admin_notice(){

            remove_all_actions('admin_notices');
            remove_all_actions('all_admin_notices');

        }
        
        public static function multi_blog_show_hide_notice( $status = false ){

            if( $status ){

                if( (class_exists( 'Booster_Extension_Class' ) ) || get_option('multi_blog_admin_notice') ){

                    return false;

                }else{

                    return true;

                }

            }

            // Check If current Page 
            if ( isset( $_GET['page'] ) && $_GET['page'] == 'multi-blog-about'  ) {
                return false;
            }

        	// Hide if dismiss notice
        	if( get_option('multi_blog_admin_notice') ){
				return false;
			}
        	// Hide if all plugin active
        	if ( class_exists( 'Booster_Extension_Class' ) && class_exists( 'Demo_Import_Kit_Class' ) && class_exists( 'Themeinwp_Import_Companion' ) ) {
				return false;
			}
			// Hide On TGMPA pages
			if ( ! empty( $_GET['tgmpa-nonce'] ) ) {
				return false;
			}
			// Hide if user can't access
        	if ( current_user_can( 'manage_options' ) ) {
				return true;
			}
			
        }

        // Define Global Value
        public static function multi_blog_admin_notice(){

            $theme_info      = wp_get_theme();
            $theme_name            = $theme_info->__get( 'Name' );
            ?>
            <div class="updated notice is-dismissible twp-multi-blog-notice">

                <p class="notice-text">
                    <?php
                    $current_user = wp_get_current_user();

                    printf(
                    /* Translators: %1$s current user display name., %2$s this theme name., %3$s discount coupon code., %4$s discount percentage. */
                        esc_html__(
                            'Howdy, %1$s! You\'ve been using %2$s theme for a while now, and we hope you\'re happy with it. We would greatly appreciate it if you could take a moment to leave a review of the %2$s theme on WordPress.org. Your feedback will help other users make an informed decision when choosing a theme for their website. Thank you!',
                            'multi-blog'
                        ),
                        '<strong>' . esc_html( $current_user->display_name ) . '</strong>',
                        $theme_name
                    );

                    ?>
                </p>

                <p>
                    <a target="_blank" class="button button-primary button-primary-upgrade" href="<?php echo esc_url( 'https://www.themeinwp.com/theme/multi-blog-pro/' ); ?>">
                        <span class="dashicons dashicons-thumbs-up"></span>
                        <span><?php esc_html_e('Upgrade to Pro','multi-blog'); ?></span>
                    </a>

                    <a class="button button-primary twp-install-active" href="javascript:void(0)">
                        <span class="dashicons dashicons-admin-plugins"></span>
                        <span><?php esc_html_e('Install and activate recommended plugins','multi-blog'); ?></span>
                    </a>
                    <span class="quick-loader-wrapper"><span class="quick-loader"></span></span>

                    <a target="_blank" class="button button-primary" href="<?php echo esc_url( 'https://live-preview.themeinwp.com/multi-blog/' ); ?>">
                        <span class="dashicons dashicons-welcome-view-site"></span>
                        <span><?php esc_html_e('View Demo','multi-blog'); ?></span>
                    </a>

                    <a target="_blank" class="button button-secondary" href="<?php echo esc_url( 'https://wordpress.org/support/theme/multi-blog/reviews/?filter=5' ); ?>">
                        <span class="dashicons dashicons-star-filled"></span> <span class="dashicons dashicons-star-filled"></span> <span class="dashicons dashicons-star-filled"></span> <span class="dashicons dashicons-star-filled"></span> <span class="dashicons dashicons-star-filled"></span>
                        <span><?php esc_html_e('Leave a review','multi-blog'); ?></span>
                    </a>

                    <a class="btn-dismiss twp-custom-setup" href="javascript:void(0)"><?php esc_html_e('Dismiss this notice.','multi-blog'); ?></a>

                </p>

            </div>

        <?php
        }

        public function multi_blog_notice_dismiss(){

        	if ( isset( $_POST[ '_wpnonce' ] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST[ '_wpnonce' ] ) ), 'multi_blog_ajax_nonce' ) ) {

	        	update_option('multi_blog_admin_notice','hide');

	        }

            die();

        }

        public function multi_blog_notice_clear_cache(){

        	update_option('multi_blog_admin_notice','');

        }

    }
    new Multi_Blog_Dashboard_Notice();
endif;