<?php
namespace DexterGpt;
defined( 'WPINC' ) || exit;
include_once __DIR__ . '/../../classes/post-meta.php';

$this->form_action();
?>
<div class="dextergpt_msg"><?php echo $this->showNotifications(); ?></div>
<h3 class="dextergpt-title-short">
	<?php echo esc_html__('Plugin Settings', 'dextergpt'); ?>
</h3>
<table class="wp-list-table striped dextergpt-table">
	<tbody>
		<tr>
			<th>Structured data</th>
			<td>
				<?php echo $this->render_select('sw_shema_type', ['microdata'=>'Microdata','json'=>'JSON-LD']); ?>
				<div class="dextergpt-desc"><?php echo esc_html__('It is important to note that this setting is exclusively designed for use with Schema markup for the FAQ section, ensuring more effective search engine interaction for your published content.', 'dextergpt'); ?></div>
			</td>
		</tr>
    <?php
    if (is_plugin_active(PostMeta::PLUGIN_ELEMENTOR)) {
        ?>
        <tr>
            <th>Elementor</th>
            <td>
                <div class="mb-1">Split incoming post into blocks:</div>
                <?php echo $this->render_select('dextergpt_split_to_elementor', ['no'=>'No', 'yes'=>'Yes']); ?>
                <div class="dextergpt-desc"><?php echo esc_html__('If "No" is selected, Elementor will not be used when creating the post.', 'dextergpt'); ?></div>
            </td>
        </tr>
        <?php
    }
    ?>
        <tr>
            <th>Debug</th>
            <td>
                <div class="mb-1">Enable debugging mode:</div>
                <?php echo $this->render_select('dextergpt_debug', ['no'=>'No','yes'=>'Yes']); ?>
                <div class="dextergpt-desc"><?php
                    echo esc_html__('We may ask you to enable debugging mode if you contact us', 'dextergpt'),
                        '<a href="'.esc_url('https://dextergpt.canny.io').'" target="blank">',
                        esc_html__('here', 'dextergpt'),
                        '</a>';
                    ?></div>
            </td>
        </tr>
	</tbody>
</table>
<?php $this->form_end(); ?>