<?php

namespace DexterGpt;

defined('WPINC') || exit;

include_once __DIR__ . '/../utils.php';

class APIClient
{
    /**
     * @var \DexterGpt
     */
    private $plugin;
    private $base_url = 'https://api2.dextergpt.com/api/v1/websites/';
    private $site_url;
    private $ssl_verify = false;
    private $http_timeout = 120;
    /**
     * @var string
     */
    public $error = '';

    const MAX_IMAGE_SIZE_KB = 1024;
    const MAX_FILENAME_LENGTH = 100;

    /**
     * @param \DexterGpt $plugin
     */
    public function __construct($plugin)
    {
        $this->plugin = $plugin;
        $this->site_url = substr($this->base_url, 0, (int)strpos($this->base_url, '/api/v1/'));
    }

    public function checkSecter($data, $secret)
    {
       return $data['secret'] === $secret;
    }

    private function request($endpoint, $body = [], $headers = [])
    {
        $headers = array_merge($headers, [
            'Content-Type' => 'application/json',
        ]);

        $args = [
            'method' => 'POST',
            'headers' => $headers,
            'timeout' => $this->http_timeout,
            'sslverify' => $this->ssl_verify,
        ];

        if (!empty($body)) {
            $args['body'] = dextergpt_json_encode_unescaped($body);
        }

        $url = $this->base_url . $endpoint;

        return wp_remote_request($url, $args);
    }

    /**
     * @param \WP_User $wpUser
     * @return array<string, int|string>
     */
    public function connect($wpUser)
    {

        $secret = md5(time() . mt_rand());

        $_data = [
            'name' => $wpUser['user_email'],
            'secret' => $secret,
            'webhook' => $wpUser['webhook'],
        ];
        if (isset($wpUser['success_url'])) {
            $_data['success_url'] = $wpUser['success_url'];
        }
        if (isset($wpUser['failure_url'])) {
            $_data['failure_url'] = $wpUser['failure_url'];
        }
        if (function_exists('rest_url')) {
            $_data['rest'] = rest_url($this->plugin->getRestNamespace());
        }

        error_log('connect data: ' . json_encode($_data, true));
       $response = $this->request('connect', $_data);
        if (is_wp_error($response)) {
            $this->error = $response->get_error_message();
            return [
                'status' => 0,
                'error' => $this->error ,
            ];
        }

        $result = wp_remote_retrieve_body($response);
        $data = @json_decode($result, true);
     
        if (is_array($data) && isset($data['status'])) {
            if ($data['status'] === 1) {
                $this->plugin->setSettings([
                    'user_id' => $wpUser['user_id'],
                    'name' => $wpUser['user_email'],
                    'secret' => $secret,
                    'api_key' => '',
                ]);
            }
            return $data;
        }

        $this->error = 'Error json_decode: ' . $result;
        return [
            'status' => 0,
            'error' => $this->error,
        ];
    }

    public function disconnect()
    {
        $settings = $this->plugin->getSettings();

        $response = $this->request('disconnect', [
            'api_key' => $settings['api_key'],
        ]);

        if (is_wp_error($response)) {
            $this->error = $response->get_error_message();
            return [
                'status' => 0,
                'error' => $this->error,
            ];
        }

        $result = wp_remote_retrieve_body($response);

        $data = @json_decode($result, true);
        if (is_array($data)) {
            $this->plugin->deleteSettings();
            return $data;
        }

        $this->error = 'Error json_decode: ' . $result;
        return [
            'status' => 0,
            'error' => $this->error,
        ];
    }

    public function checkImageUrl($url)
    {
        return true;
        if (strpos($url, $this->site_url) === 0) {
            return preg_match('#^/docs/[0-9]+/[0-9a-z]+/[0-9]+/[0-9a-z]+\.(jpg|gif|png|webp)$#', substr($url, strlen($this->site_url)));
        }
        return false;
    }


    public function loadImage($url, $filename = '')
    {

        $response = wp_remote_get($url);
        error_log('İMG YÜKLEMEDE !0 TEST' . wp_remote_retrieve_response_code($response));
        if ( ! function_exists('wp_tempnam') ) {
            require_once( ABSPATH . 'wp-admin/includes/file.php' );
        }
        if (is_wp_error($response)) {
            error_log('wp_remote_get error: ' . $response->get_error_message());
            $this->error = $response->get_error_message();
            return false;
        } elseif (wp_remote_retrieve_response_code($response) === 200) {
            error_log('İMG YÜKLEMEDE !0.1');
            $content_type = wp_remote_retrieve_header($response, 'content-type');
            $size = wp_remote_retrieve_header($response, 'content-length');
            if (is_array($size)) {
                $size = $size[0];
            }
            $size = (int)$size;
            $mimes = get_allowed_mime_types();

            if (($size > 0) && ($size <= (self::MAX_IMAGE_SIZE_KB * 1024)) && in_array($content_type, $mimes)) {
                $tmp_name = wp_tempnam();
                error_log('İMG YÜKLEMEDE !1');
                if (@file_put_contents($tmp_name, wp_remote_retrieve_body($response))) {
                    $image_size = @getimagesize($tmp_name);
                    error_log('İMG YÜKLEMEDE !2'.$content_type);
                    error_log('İMG YÜKLEMEDE !2' . json_encode($image_size));
                   // $content_type = $image_size['mime'];
                    if ($image_size && ($image_size['mime'] === $content_type)) {
                        error_log('İMG YÜKLEMEDE !3');

                        $name = basename($url);
                        if (strlen($filename) > 0) {
                            error_log('İMG YÜKLEMEDE !4');

                            $filename = trim($filename, " \n\r\t.?!;:/\\#");

                            if (strlen($filename) > 0) {
                                error_log('İMG YÜKLEMEDE !5');

                                $ext = substr($name, (int)strrpos($name, '.'));
                                $max_length = self::MAX_FILENAME_LENGTH - strlen($ext);
                                error_log('Max Length: ' . $max_length);
                                error_log('Filename: ' . $filename);
                                error_log('Filename Length: ' . mb_strlen($filename, \DexterGpt::MB_ENCODING));

                                if (mb_strlen($filename, \DexterGpt::MB_ENCODING) > $max_length) {
                                    error_log('İMG YÜKLEMEDE !6');

                                    $_name = mb_substr($filename, 0, $max_length, \DexterGpt::MB_ENCODING);

                                    if (preg_match('/^\s/us', mb_substr($filename, $max_length, 1, \DexterGpt::MB_ENCODING))) {
                                        $filename = trim($_name);
                                    } else {
                                        $filename = preg_replace('/^(.+)\s+\S+$/us', '\\1', $_name);
                                    }
                                }

                                $name = $filename . $ext;
                            }
                        }

                        return [
                            'name' => sanitize_file_name($name),
                            'type' => $image_size['mime'],
                            'tmp_name' => $tmp_name,
                            'error' => UPLOAD_ERR_OK,
                            'size' => $size
                        ];
                    }
                } else {
                    $this->error = 'file_put_contents(' . $tmp_name . ') ' . $size . ' bytes';
                }
                @unlink($tmp_name);
            }
        } else {
            $this->error = 'response_code=' . wp_remote_retrieve_response_code($response);
        }


        return false;
    }


    public function deleteImage($file)
    {
        if (isset($file['tmp_name']) && file_exists($file['tmp_name'])) {
            @unlink($file['tmp_name']);
        }
    }
}
