(function ($) {
    const action = 'dextergpt_settings';
    var conection_button = '#dextergpt_conection_button';

    var tabs = $( '[data-dextergpt-tab]' );
    if(tabs.length){
        tabs.on( 'click', function ( _event ) {
            dextergpt_display_tab($( this ).data('dextergpt-tab'));
            document.cookie = 'dextergpt_tab=' + $( this ).data('dextergpt-tab');
            $(this).blur();
        } );
        var tab = dextergpt_tab_cookie(tabs);
        if ( tab.length < 1 ) {
            tab = tabs.first();
        }
        dextergpt_display_tab(tab.data( 'dextergpt-tab' ));
    }

    function dextergpt_tab_cookie( $elems ) {
        var re = new RegExp(
            '(?:^|.*;)\\s*dextergpt_tab\\s*=\\s*([^;]*).*$|^.*$',
            'ms'
        );
        var name = document.cookie.replace( re, "$1" );
        return $elems.filter( '[data-dextergpt-tab="' + name + '"]:first' );
    }

    function dextergpt_display_tab(name) {
        var tabs = $( '[data-dextergpt-tab]' );
        var layouts = $( '[data-dextergpt-layout]' );
        tabs.removeClass( 'nav-tab-active' );
        tabs.filter( '[data-dextergpt-tab="' + name + '"]' ).addClass( 'nav-tab-active' );
        layouts.hide();
        layouts.filter( '[data-dextergpt-layout="' + name + '"]' ).show();
    }

    function disableBtn(s, v) {
        if (v) {
            $(s).addClass( 'disabled' );
        }else{
            $(s).removeClass( 'disabled' );
        }
    }

    function hideMsg() {
        $('.dextergpt_msg').hide();
    }

    function hideMsgWithDelay() {
        setTimeout(hideMsg, 5000);
    }

    function showMsg(msg) {
        $('.dextergpt_msg').html(msg).show();
        hideMsgWithDelay();
    }

    function aj(command, success) {
        var data = {
            'action': action,
            'aj': command,
            'nonce': ajax_var.nonce
        };

        $.post(ajaxurl, data, success, 'json');
    }

    function connectOrDisconnect(event) {
        event.preventDefault();
        disableBtn(conection_button, true);
        hideMsg();
        var type = $(conection_button).attr('href') == '#connect' ? 'connect' : 'disconnect';
        aj(type, function(d){
            if ('success' in d) {
                if (d.success) {
                    if ('auth_url' in d) {
                        window.location.assign(d.auth_url);
                    }
                    else {
                        showMsg(d.msg);
                        if($('.conection-message').length){
                            $('.conection-message').html(d.body)
                        }
                    }
                    if(type == 'disconnect'){
                        disableBtn(conection_button, false);
                        $('.conection-blok').removeClass('connected');
                        $(conection_button).html('Connect').attr('href','#connect');
                    }
                }
                else {
                    if ('error' in d) {
                        showMsg(d.error);
                    }
                    disableBtn(conection_button, false);
                }
            }
            else {
                disableBtn(conection_button, false);
            }
        });
    }

    $(document).ready(function () {
        if($(conection_button).length){
            $(conection_button).click(connectOrDisconnect);
        }
        if ($('.dextergpt_msg').length) {
            hideMsgWithDelay();
        }
    });
})(jQuery);
