<?php
if (!defined('ABSPATH')) {
    exit;
}

$apiKey = TIDN_Helpers::getApiKey();
$emailVerified = false;
$email = esc_html__('Not specified', '2index-page-indexer');
$plan = esc_html__('Not selected', '2index-page-indexer');

if ($apiKey) {
    $api = new TIDN_Api($apiKey);
    $response = $api->account();

    if (TIDN_Helpers::isQuerySuccess($response)) {
        $email = esc_html($response['account']['email'] ?? $email);
        $plan = esc_html($response['account']['tariff'] ?? $plan);
        $emailVerified = $response['account']['email_verified'] ?? false;
    }

    if (TIDN_Helpers::isQueryError($response)) {
        add_settings_error('index_ninja_api_key', 'index_ninja_api_key_error', TIDN_Helpers::getQueryErrorMessage($response), 'error');
    }

    if (!$emailVerified) {
        add_settings_error('index_ninja_api_key', 'index_ninja_api_key_error', esc_html__('You must verify your email address to work with plugin', '2index-page-indexer'), 'error');
    }
}
?>

<div class="wrap index-ninja-container index-ninja-settings">
    <a href="https://2index.ninja" target="_blank" rel="noopener noreferrer">
        <img src="<?php echo esc_url(TIDN_get_plugin_dir_url()); ?>/assets/svg/logo.svg" alt="Logo 2Index Ninja">
    </a>
    <h1><?php esc_html_e('Settings', '2index-page-indexer'); ?></h1>
    <?php settings_errors(); ?>

    <?php if (!$apiKey) { ?>
        <div class="index-ninja-settings-section">
            <form method="post" action="<?php echo esc_url(admin_url('admin.php?page=index-ninja-settings')); ?>">
                <button type="submit" class="button button-primary" id="index-create-account">
                    <?php esc_html_e('Create an account', '2index-page-indexer'); ?>
                </button>
                <input type="hidden" name="action" value="register-user">
                <p><?php esc_html_e('The account will be automatically created in the 2Index.ninja service. The website administrator\'s email address will be used for registration.', '2index-page-indexer'); ?>
                    <a href="https://2index.ninja" target="_blank" rel="noopener noreferrer"><?php esc_html_e('2Index.ninja', '2index-page-indexer'); ?></a></p>
            </form>
        </div>

        <div class="index-ninja-settings-section">
            <button type="button" class="button" id="index-set-api-key"><?php esc_html_e('Set API key', '2index-page-indexer'); ?></button>
            <p id="index-set-api-key-text"><?php esc_html_e('If you have an account in', '2index-page-indexer'); ?> <a href="https://2index.ninja" target="_blank" rel="noopener noreferrer">2Index.ninja</a>
            </p>
            <?php include_once plugin_dir_path(__FILE__) . 'api-key-form.php'; ?>
        </div>

    <?php } else { ?>
        <h2><?php esc_html_e('Credentials', '2index-page-indexer'); ?></h2>
        <div class="index-ninja-settings-section">
            <p><strong><?php esc_html_e('E-mail:', '2index-page-indexer'); ?></strong> <?php echo $email; ?></p></div>
        <div class="index-ninja-settings-section">
            <p id="index-set-api-key-text"><strong><?php esc_html_e('API key:', '2index-page-indexer'); ?></strong> <?php echo esc_html(substr($apiKey, 0, 3) . "..." . substr($apiKey, -3)); ?>
            </p>
            <button type="button" class="button" id="index-set-api-key"><?php esc_html_e('Update API key', '2index-page-indexer'); ?></button>
            <?php include_once plugin_dir_path(__FILE__) . 'api-key-form.php'; ?>
        </div>
        <div class="index-ninja-settings-section">
            <p><strong><?php esc_html_e('Plan:', '2index-page-indexer'); ?></strong> <?php echo $plan; ?></p>
            <a href="https://2index.ninja/account/plans" target="_blank" rel="noopener noreferrer" class="button button-primary"><?php esc_html_e('Upgrade plan', '2index-page-indexer'); ?></a>
        </div>
    <?php } ?>
</div>