<?php
if (!defined('ABSPATH')) exit; // Exit if accessed directly.

$apiKey = TIDN_Helpers::getApiKey();
$api = new  TIDN_Api($apiKey);
$account = $api->account();
$project = null;
$sources = null;

if ($account) {
    $account = $account['account'];
    $project = $api->get_wordpress_project(trailingslashit(get_site_url()));
    if (TIDN_Helpers::isQueryError($project)) {
        add_settings_error('index_ninja_api_key', 'index_ninja_api_key_error', TIDN_Helpers::getQueryErrorMessage($project), 'error');
    }
    if ($project && isset($project['project'])) {
        $project = $project['project'];
        $sources = $api->get_link_sources($project['id']);
    }
}
?>

<div class="wrap index-ninja-container index-ninja-indexing-pages">
    <a href="https://2index.ninja" target="_blank" rel="noopener noreferrer">
        <img src="<?php echo esc_url( TIDN_get_plugin_dir_url() ); ?>/assets/svg/logo.svg" alt="Logo 2Index Ninja">
    </a>
    <h1>Indexing pages</h1>
    <?php settings_errors(); ?>
    <?php if ($project) { ?>
        <h2><?php esc_html_e('Plan', '2index-page-indexer'); ?></h2>
        <div class="index-ninja-section">
            <div class="block-tariff"><?php esc_html_e('Tariff', '2index-page-indexer'); ?> <strong><?php echo esc_html($account['tariff']); ?></strong></div>
            <div class="block-info">
                <div class="info-item"><strong><?php esc_html_e('Available projects', '2index-page-indexer'); ?></strong> <?php echo esc_html($account['available_projects']); ?></div>
                <div class="info-item"><strong><?php esc_html_e('Available links', '2index-page-indexer'); ?></strong> <?php echo esc_html($account['available_links']); ?></div>
                <div class="info-item"><strong><?php esc_html_e('Link sending speed', '2index-page-indexer'); ?></strong> <?php echo esc_html($account['link_sending_speed']); ?>
                    / <?php esc_html_e('day', '2index-page-indexer'); ?></div>
                <div class="info-item"><strong><?php esc_html_e('Price', '2index-page-indexer'); ?></strong> <?php echo esc_html($account['link_cost']); ?>
                    / <?php esc_html_e('link', '2index-page-indexer'); ?></div>
            </div>
        </div>
        <a href="<?php echo esc_url(admin_url('admin.php?page=index-ninja-indexing-pages&action=add-pages')); ?>"
           class="button button-primary"><?php esc_html_e('Add pages', '2index-page-indexer'); ?></a>
        <?php if ($sources) { ?>
            <h4><?php esc_html_e('Sources', '2index-page-indexer'); ?></h4>
            <div class="index-ninja-section">
                <table class="index-ninja-table" id="sources-table">
                    <thead>
                    <tr>
                        <th><?php esc_html_e('Source', '2index-page-indexer'); ?></th>
                        <th><?php esc_html_e('Type', '2index-page-indexer'); ?></th>
                        <th><?php esc_html_e('Added', '2index-page-indexer'); ?></th>
                        <th><?php esc_html_e('Processed', '2index-page-indexer'); ?></th>
                        <th><?php esc_html_e('Status', '2index-page-indexer'); ?></th>
                        <th><?php esc_html_e('Found links', '2index-page-indexer'); ?></th>
                        <th><?php esc_html_e('Added links', '2index-page-indexer'); ?></th>
                        <th><?php esc_html_e('Incorrect links', '2index-page-indexer'); ?></th>
                        <th><?php esc_html_e('Watch', '2index-page-indexer'); ?></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($sources as $source) { ?>
                        <tr id="source-tr-<?php echo esc_attr($source['id']); ?>">
                            <td>
                                <?php if ($source['type'] === 'sitemap') { ?>
                                    <a href="<?php echo esc_url($source['name']); ?>" title="<?php esc_attr_e('Go to sitemap', '2index-page-indexer'); ?>"
                                       target="_blank"><?php echo esc_html($source['name']); ?></a>
                                <?php } else { ?>
                                    <?php echo esc_html($source['name']); ?>
                                <?php } ?>
                            </td>
                            <td><?php echo esc_html($source['type']); ?></td>
                            <td><?php echo esc_html(gmdate('Y-m-d H:i:s', strtotime($source['created_at']))); ?></td>
                            <!-- ... (esc_html для всех выводимых значений $source) -->
                            <td>
                                <?php
                                if ($source['processing_date']) {
                                    echo esc_html(gmdate('Y-m-d H:i:s', strtotime($source['processing_date'])));
                                } else {
                                    echo esc_html('Not processed');
                                }
                                ?>
                            </td>
                            <td>
                                <?php
                                if ($source['status'] === 'error') {
                                    echo '<span class="text-red pointer dashed" title="' . esc_attr($source['error_message']) . '">' . esc_html($source['status']) . '</span>';
                                } else {
                                    echo '<span class="text-green">' . esc_html($source['status']) . '</span>';
                                }
                                ?>
                            </td>
                            <td><?php echo esc_html($source['total_links']); ?></td>
                            <td><?php echo esc_html($source['added_links']); ?></td>
                            <td><?php echo esc_html($source['invalid_links']); ?></td>
                            <td class="text-center watch-icons">
                                <?php if ($source['type'] == 'sitemap') { ?>
                                    <button class="button-toggle-watch-status <?php echo esc_attr($source['watch'] ? 'watched' : ''); ?>" data-id="<?php echo esc_attr($source['id']); ?>"></button>

                                <?php } ?>
                            </td>
                            <td>
                                <button class="button-simple button-remove-source" data-id="<?php echo esc_attr($source['id']); ?>">
                                    <?php esc_html_e('delete', '2index-page-indexer'); ?>
                                </button>

                            </td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
                <div id="no-sources-found" style="display: none;"><?php esc_html_e('No sources found', '2index-page-indexer'); ?></div>
            </div>
        <?php } ?>

        <h4><?php esc_html_e('Sent links', '2index-page-indexer'); ?></h4>
        <div class="index-ninja-section">
            <div class="index-ninja-sent-info">
        <span title="<?php esc_attr_e('Sent links to Google', '2index-page-indexer'); ?>">
            <img src="<?php echo esc_url(TIDN_get_plugin_dir_url()); ?>/assets/svg/google.svg" alt="<?php esc_attr_e('Google sent links', '2index-page-indexer'); ?>">
            <?php echo esc_html($project['links_sent_google'] ?? 0); ?>
        </span>
                <span title="<?php esc_attr_e('Sent links to Yandex', '2index-page-indexer'); ?>">
            <img src="<?php echo esc_url(TIDN_get_plugin_dir_url()); ?>/assets/svg/yandex.svg" alt="<?php esc_attr_e('Yandex sent links', '2index-page-indexer'); ?>">
            <?php echo esc_html($project['links_sent_yandex'] ?? 0); ?>
        </span>
                <span title="<?php esc_attr_e('Sent links to Bing', '2index-page-indexer'); ?>">
            <img src="<?php echo esc_url(TIDN_get_plugin_dir_url()); ?>/assets/svg/bing.svg" alt="<?php esc_attr_e('Bing sent links', '2index-page-indexer'); ?>">
            <?php echo esc_html($project['links_sent_bing'] ?? 0); ?>
        </span>
            </div>
        </div>

        <h4><?php esc_html_e('Statistics', '2index-page-indexer'); ?></h4>
        <div class="index-ninja-section">
            <table class="index-ninja-table">
                <thead>
                <tr>
                    <th><?php esc_html_e('Status', '2index-page-indexer'); ?></th>
                    <th><?php esc_html_e('Count', '2index-page-indexer'); ?></th>
                    <th><?php esc_html_e('Actions', '2index-page-indexer'); ?></th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td><strong><?php esc_html_e('In queue', '2index-page-indexer'); ?></strong></td>
                    <td class="text-center" id="td-queue-count">
                        <?php echo esc_html($project['in_queue'] ?? 0); ?>
                    </td>
                    <td>
                        <?php if (isset($project['download_queue_url'])) { ?>
                            <a href="<?php echo esc_url($project['download_queue_url']); ?>" class="button button-primary" title="<?php esc_attr_e('Download report', '2index-page-indexer'); ?>"
                                target="_blank"><?php esc_html_e('Download report', '2index-page-indexer'); ?></a>
                        <?php } ?>
                        <button class="button" id="clear-queue-button"
                                data-url="<?php echo esc_url(admin_url('admin.php?page=index-ninja-indexing-pages&action=clear-queue')); ?>"><?php esc_html_e('Clear queue', '2index-page-indexer'); ?></button>
                    </td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('Sent', '2index-page-indexer'); ?></strong></td>
                    <td class="text-center">
                        <?php echo esc_html($project['sent_links'] ?? 0); ?>
                    </td>
                    <td>
                        <?php if (isset($project['download_sent_url'])) { ?>
                            <a href="<?php echo esc_url($project['download_sent_url']); ?>" class="button button-primary" title="<?php esc_attr_e('Download report', '2index-page-indexer'); ?>"
                               target="_blank"><?php esc_html_e('Download report', '2index-page-indexer'); ?></a>
                        <?php } ?>
                    </td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('Indexed', '2index-page-indexer'); ?></strong>
                        <small><?php esc_html_e('*Indexing statistics are only available for Google', '2index-page-indexer'); ?></small>
                    </td>
                    <td class="text-center">
                        <?php echo esc_html($project['indexed'] ?? 0); ?>
                    </td>
                    <td>
                        <?php if (isset($project['download_indexed_url'])) { ?>
                            <a href="<?php echo esc_url($project['download_indexed_url']); ?>" class="button button-primary" title="<?php esc_attr_e('Download report', '2index-page-indexer'); ?>"
                               target="_blank"><?php esc_html_e('Download report', '2index-page-indexer'); ?></a>
                        <?php } ?>
                    </td>
                </tr>
                <tr>
                    <td><strong><?php esc_html_e('Not indexed', '2index-page-indexer'); ?></strong></td>
                    <td class="text-center">
                        <?php echo esc_html($project['not_indexed'] ?? 0); ?>
                    </td>
                    <td>
                        <?php if (isset($project['download_unindexed_url'])) { ?>
                            <a href="<?php echo esc_url($project['download_unindexed_url']); ?>" class="button button-primary" title="<?php esc_attr_e('Download report', '2index-page-indexer'); ?>"
                               target="_blank"><?php esc_html_e('Download report', '2index-page-indexer'); ?></a>
                        <?php } ?>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    <?php } else { ?>
        <h2><?php esc_html_e('Failed to load project data', '2index-page-indexer'); ?></h2>
    <?php } ?>
</div>