<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap index-ninja-container index-ninja-indexing-pages">
    <a href="https://2index.ninja" target="_blank" rel="noopener noreferrer">
        <img src="<?php echo esc_url(TIDN_get_plugin_dir_url()); ?>/assets/svg/logo.svg" alt="Logo 2Index Ninja">
    </a>
    <h1><?php esc_html_e('Add pages to index', '2index-page-indexer'); ?></h1>
    <?php settings_errors(); ?>

    <form method="post" id="add-pages-form"
          action="<?php echo esc_url(admin_url('admin.php?page=index-ninja-indexing-pages&action=add-pages')); ?>"
          enctype="multipart/form-data">
        <h2><?php esc_html_e('Search engines', '2index-page-indexer'); ?></h2>
        <p><?php esc_html_e('Select the search engines you want to index your links:', '2index-page-indexer'); ?></p>
        <div class="index-ninja-section engines-wrapper">
            <div class="error-wrapper">
                <div class="block-engine">
                    <div class="info-item">
                        <input type="checkbox" id="google" name="add-pages-form-engine[]" value="google">
                        <label for="google"><?php esc_html_e('Google', '2index-page-indexer'); ?></label>
                    </div>
                    <div class="info-item">
                        <input type="checkbox" id="yandex" name="add-pages-form-engine[]" value="yandex">
                        <label for="yandex"><?php esc_html_e('Yandex', '2index-page-indexer'); ?></label>
                    </div>
                    <div class="info-item">
                        <input type="checkbox" id="bing" name="add-pages-form-engine[]" value="bing">
                        <label for="bing"><?php esc_html_e('Bing', '2index-page-indexer'); ?></label>
                    </div>
                </div>
                <span class="error-text" id="add-pages-form-engine-error" style="display: none;"></span>
            </div>
        </div>

        <h2><?php esc_html_e('Source of pages', '2index-page-indexer'); ?></h2>
        <div class="index-ninja-section">
            <select id="add-pages-form-source" name="add-pages-form-source">
                <option value=""><?php esc_html_e('Please select import type', '2index-page-indexer'); ?></option>
                <option value="sitemap"><?php esc_html_e('Sitemap link', '2index-page-indexer'); ?></option>
                <option value="list"><?php esc_html_e('List of links', '2index-page-indexer'); ?></option>
                <option value="file"><?php esc_html_e('Import from file', '2index-page-indexer'); ?></option>
            </select>
        </div>

        <div id="sitemap-section" class="form-section">
            <h2><?php esc_html_e('Sitemap link form', '2index-page-indexer'); ?></h2>
            <div class="index-ninja-settings-section">
                <div class="error-wrapper">
                    <input type="text" id="add-pages-form-sitemap-link" name="add-pages-form-sitemap-link" placeholder="<?php esc_attr_e('Enter sitemap link', '2index-page-indexer'); ?>">
                    <span class="error-text"></span>
                </div>
                <button type="submit" class="button button-primary"><?php esc_html_e('Send', '2index-page-indexer'); ?></button>
                <div class="w-100">
                    <input type="checkbox" id="submit-all-new-pages" name="submit-all-new-pages" value="1">
                    <label for="submit-all-new-pages"><?php esc_html_e('Submit all new pages in the sitemap files for indexing', '2index-page-indexer'); ?></label>
                </div>
            </div>
        </div>

        <div id="list-section" class="form-section">
            <h2><?php esc_html_e('List form', '2index-page-indexer'); ?></h2>
            <div class="index-ninja-settings-section">
                <div class="error-wrapper">
                    <textarea id="add-pages-form-list-links" name="add-pages-form-list-links"
                              placeholder="<?php esc_attr_e('Add a list of pages to index, each page on a new line', '2index-page-indexer'); ?>"></textarea>
                    <span class="error-text"></span>
                </div>
                <button type="submit" class="button button-primary"><?php esc_html_e('Send', '2index-page-indexer'); ?></button>
                <div class="w-100">
                    <p>*<?php esc_html_e('You can add a maximum of 1000 links to this field at a time', '2index-page-indexer'); ?></p>
                </div>
            </div>
        </div>

        <div id="file-section" class="form-section">
            <h2><?php esc_html_e('File form', '2index-page-indexer'); ?></h2>
            <div class="index-ninja-settings-section">
                <div class="error-wrapper">
                    <label for="add-pages-form-file-input" class="button"><?php esc_html_e('Select file', '2index-page-indexer'); ?></label>
                    <input type="file" id="add-pages-form-file-input" name="add-pages-form-file-input" accept=".txt" style="display: none;">
                    <span class="error-text"></span>
                </div>
                <button type="submit" class="button button-primary"><?php esc_html_e('Send', '2index-page-indexer'); ?></button>
                <div class="w-100">
                    <p>*<?php esc_html_e('The file must be in txt format.', '2index-page-indexer'); ?></p>
                    <p>*<?php esc_html_e('The maximum file size is no more than 50 MB.', '2index-page-indexer'); ?></p>
                    <p>*<?php esc_html_e('The maximum number of links in a file is 100,000.', '2index-page-indexer'); ?></p>
                </div>
            </div>
        </div>
    </form>
</div>