<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap index-ninja-container index-ninja-main">
    <a href="https://2index.ninja" target="_blank" rel="noopener noreferrer">
        <img src="<?php echo esc_url(TIDN_get_plugin_dir_url()); ?>/assets/svg/logo.svg" alt="Logo 2Index Ninja">
    </a>
    <h1><?php esc_html_e('2Index.ninja Page Indexer', '2index-page-indexer'); ?></h1>
    <p><?php esc_html_e('This plugin simplifies the process of indexing your website pages in Google, Yandex and Bing search engines. It uses the 2index.ninja API to automatically submit pages for indexing. You can upload pages via a sitemap, list or text file. The plugin supports multiple sites with one account, provides automatic processing of new pages and displays the indexing status: “Indexed” or “Not indexed”. Compatible with WordPress versions 4.0 and higher.', '2index-page-indexer'); ?></p>

    <div class="index-ninja-buttons">
        <a href="<?php echo esc_url(admin_url('admin.php?page=index-ninja-indexing-pages')); ?>" class="button button-primary"><?php esc_html_e('Indexing Pages', '2index-page-indexer'); ?></a>
        <a href="<?php echo esc_url(admin_url('admin.php?page=index-ninja-settings')); ?>" class="button"><?php esc_html_e('Settings', '2index-page-indexer'); ?></a>
        <a href="<?php echo esc_url(admin_url('admin.php?page=index-ninja-faq')); ?>" class="button"><?php esc_html_e('FAQ', '2index-page-indexer'); ?></a>
    </div>
</div>