<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap index-ninja-container index-ninja-faq">
    <a href="https://2index.ninja" target="_blank" rel="noopener noreferrer">
        <img src="<?php echo esc_url(TIDN_get_plugin_dir_url()); ?>/assets/svg/logo.svg" alt="Logo 2Index Ninja">
    </a>
    <h1><?php esc_html_e('Frequently Asked Questions', '2index-page-indexer'); ?></h1>
    <dl>
        <dt><?php esc_html_e('1. How to start using the plugin?', '2index-page-indexer'); ?></dt>
        <dd><?php esc_html_e('First, install the plugin on your WordPress site. After activation, go to the settings to enter the API key from the 2index.ninja service and configure the indexing parameters.', '2index-page-indexer'); ?></dd>

        <dt><?php esc_html_e('2. Which search engines are supported?', '2index-page-indexer'); ?></dt>
        <dd><?php esc_html_e('The plugin supports indexing in Google, Yandex and Bing.', '2index-page-indexer'); ?></dd>

        <dt><?php esc_html_e('3. How to add pages for indexing?', '2index-page-indexer'); ?></dt>
        <dd><?php esc_html_e('Pages can be uploaded via a sitemap, a text file, or by manually specifying a list of pages.', '2index-page-indexer'); ?></dd>

        <dt><?php esc_html_e('4. What to do if the pages are not indexed?', '2index-page-indexer'); ?></dt>
        <dd><?php esc_html_e('If the page is not indexed, check the status via the plugin and make sure that it meets the requirements of search engines for indexing.', '2index-page-indexer'); ?></dd>

        <dt><?php esc_html_e('5. Can I use the plugin on multiple sites?', '2index-page-indexer'); ?></dt>
        <dd><?php esc_html_e('Yes, the plugin supports working on multiple sites with one 2index.ninja account.', '2index-page-indexer'); ?></dd>

        <dt><?php esc_html_e('6. How does automatic indexing work?', '2index-page-indexer'); ?></dt>
        <dd><?php esc_html_e('The plugin allows you to automatically send new pages for indexing if they are added to the sitemap.', '2index-page-indexer'); ?></dd>

        <dt><?php esc_html_e('7. Which languages does the plugin support?', '2index-page-indexer'); ?></dt>
        <dd><?php esc_html_e('The plugin is available in English, Russian, Urkainian, Spanish.', '2index-page-indexer'); ?></dd>

        <dt><?php esc_html_e('8. How to change indexing settings?', '2index-page-indexer'); ?></dt>
        <dd><?php esc_html_e('The settings can be changed on the plugin settings page in your WordPress.', '2index-page-indexer'); ?></dd>

        <dt><?php esc_html_e('9. Can I submit pages for indexing for free?', '2index-page-indexer'); ?></dt>
        <dd><?php esc_html_e('Yes, you can submit up to 100 pages for indexing for free in all three search engines (Google, Yandex, and Bing) via the 2index.ninja service.', '2index-page-indexer'); ?></dd>
    </dl>
</div>