<?php

/**
 * Class  TIDN_Api for working with the 2index.ninja API
 */
class TIDN_Api
{
    private $url = 'https://2index.ninja/api/v1/';
    private $access_token;

    /**
     * @param $access_token
     */
    public function __construct($access_token = null)
    {
        $this->access_token = $access_token;
    }

    /**
     * @return array|mixed
     */
    public function account()
    {
        return $this->make_request('account');
    }

    /**
     * @param $id
     * @return array|mixed
     */
    public function project($id)
    {
        return $this->make_request('project/' . $id);
    }

    /**
     * @return array|mixed
     */
    public function projects_list()
    {
        return $this->make_request('project');
    }

    /**
     * @param $name
     * @param $website
     * @param $for_external_links
     * @param $indexing_speed
     * @return array|mixed
     */
    public function add_project($name, $website, $for_external_links = 0, $indexing_speed = null)
    {
        return $this->make_request('project', [
            'name' => $name,
            'website' => $website,
            'external_links' => $for_external_links,
            'indexing_speed' => $indexing_speed,
        ]);
    }

    /**
     * @param $website
     * @return array|mixed
     */
    public function get_wordpress_project($website)
    {
        return $this->make_request('account/get_wordpress_project', [
            'website' => $website,
        ]);
    }

    /**
     * @param $project_id
     * @param $links
     * @param $google
     * @param $yandex
     * @param $bing
     * @param $google_access_granted
     * @return array|mixed
     */
    public function add_links($project_id, $links, $google = false, $yandex = false, $bing = false, $google_access_granted = false)
    {
        return $this->make_request('link/add', [
            'project_id' => $project_id,
            'links' => $links,
            'google' => $google ? 1 : 0, // Преобразуем boolean в 1/0
            'yandex' => $yandex ? 1 : 0,
            'bing' => $bing ? 1 : 0,
            'google_access_granted' => $google_access_granted ? 1 : 0,
        ]);
    }

    /**
     * @param $project_id
     * @return array|mixed
     */
    public function clear_queue($project_id)
    {
        return $this->make_request('project/' . $project_id . '/clear_queue', ['erase' => 1]);
    }

    /**
     * @param $email
     * @param $source
     * @return array|mixed
     */
    public function register_user($email, $source = 'wordpress_plugin')
    {
        return $this->make_request('register', [
            'email' => $email,
            'source' => $source,
        ]);
    }

    /**
     * @param $project_id
     * @return array|mixed
     */
    public function get_link_sources($project_id)
    {
        return $this->make_request('link_sources', [
            'project_id' => $project_id,
        ]);
    }

    /**
     * @param $project_id
     * @param $sitemap
     * @param $google
     * @param $yandex
     * @param $bing
     * @param $google_access_granted
     * @param $watch
     * @return array|mixed
     */
    public function add_sitemap($project_id, $sitemap, $google = false, $yandex = false, $bing = false, $google_access_granted = false, $watch = false)
    {
        return $this->make_request('sitemap/add', [
            'project_id' => $project_id,
            'sitemap' => $sitemap,
            'google' => $google ? 1 : 0,
            'yandex' => $yandex ? 1 : 0,
            'bing' => $bing ? 1 : 0,
            'google_access_granted' => $google_access_granted ? 1 : 0,
            'watch' => $watch ? 1 : 0,
        ]);
    }

    /**
     * @param $project_id
     * @param $sitemap_id
     * @param $watch
     * @return array|mixed
     */
    public function update_sitemap_watch($project_id, $sitemap_id, $watch)
    {
        return $this->make_request('sitemap/update_watch', [
            'project_id' => $project_id,
            'sitemap_id' => $sitemap_id,
            'watch' => $watch ? 1 : 0,
        ]);
    }

    /**
     * @param $project_id
     * @param $sitemap_id
     * @return array|mixed
     */
    public function delete_sitemap($project_id, $sitemap_id)
    {
        return $this->make_request('sitemap/delete', [
            'project_id' => $project_id,
            'sitemap_id' => $sitemap_id,
        ]);
    }

    /**
     * @param $endpoint
     * @param $post_data
     * @return array|mixed
     */
    private function make_request($endpoint, $post_data = [])
    {
        $url = $this->url . $endpoint;
        $args = [
            'headers' => [],
            'timeout' => 30,
        ];

        if ($this->access_token) {
            $args['headers']['Authorization'] = 'Bearer ' . $this->access_token;
        }

        if ($post_data) {
            $args['method'] = 'POST';
            $args['body'] = $post_data;
        }

        $response = wp_remote_request($url, $args);

        if (is_wp_error($response)) {
            return ['success' => false, 'message' => 'Request failed: ' . $response->get_error_message()];
        }

        $body = wp_remote_retrieve_body($response);
        return json_decode($body, true);
    }
}